using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This exception is thrown when server returns fault message indicating 
	/// that there are no job slots available at the M server.
	/// This exception is fatal - VistALink connection is dropped before the exception is thrown.
	/// </summary>
	public class NoJobSlotsAvailableException : SystemFaultException
	{
		/// <summary>
		/// This constructor accepts fault info object containing 
		/// information about a fault occured at server side.
		/// </summary>
		/// <param name="faultInfo">
		///		Fault info object containing information about a fault
		///		occured at server side.
		///	</param>
		public NoJobSlotsAvailableException( FaultInfo faultInfo )
			: base( faultInfo, true ) {}
	}
}
